<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

$pdf_base64_raw = '';
$aadhaar = '';
$show_preview = false;
$result_data = [];
$error_msg = '';

// Service Name
$service_name = 'eshram_pdf';

// Fetch service price from database
$priceRow = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT price FROM pricing WHERE service_name='$service_name'"));

if ($priceRow) {
    $fee = (float)$priceRow['price'];
} else {
    // If price not set in DB, set to 0 or handle error
    $fee = 0;
}

if (isset($_POST['find'])) {
    $aadhaar = trim(mysqli_real_escape_string($ahk_conn, $_POST['aadhaar']));
    $username = $udata['phone'];
    $wallet_amount = (float)$udata['balance'];
    $debit_fee = $wallet_amount - $fee;

    if ($wallet_amount >= $fee) {
        // Validate API Config
        if (empty($new_api_key) || empty($new_api_url)) {
            echo "<script>Swal.fire('System Error', 'New API Configuration Missing. Please check settings.', 'error');</script>";
        } else {
            // Build API URL
            // URL: https://run.rtyu.tech/api/v1/index.php?api_key=...&service=eshram-card&uid=...
            $base_url = rtrim($new_api_url, '/');
            // Ensure we point to the correct endpoint. Assuming new_api_url is 'https://run.rtyu.tech/api/v1' or similar base.
            // The user example was 'https://run.rtyu.tech/api/v1/index.php'
            
            // If new_api_url contains 'index.php', remove it to be safe or just use it.
            // Let's assume new_api_url is the base path.
            // Safe construction:
            if (strpos($new_api_url, 'index.php') === false) {
                 $api_endpoint = $base_url . '/index.php';
            } else {
                 $api_endpoint = $new_api_url;
            }

            $params = [
                'api_key' => $new_api_key,
                'service' => 'eshram-card',
                'uid'     => $aadhaar
            ];
            
            // Using POST to be safe
            $ch = curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => $api_endpoint,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => http_build_query($params),
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_TIMEOUT => 60,
                CURLOPT_FOLLOWLOCATION => true
            ]);
            
            $response = curl_exec($ch);
            $curl_error = curl_error($ch);
            curl_close($ch);

            if ($curl_error) {
                echo "<script>Swal.fire('API Error', '" . addslashes($curl_error) . "', 'error');</script>";
            } else {
                $result = json_decode($response, true);
                
                // Debug response if needed
                // file_put_contents('debug_eshram.txt', $response);

                // Parse Response
                // Structure: { status: 'success', data: { status: 'success', data: { status: '100', pdf: '...' } } }
                // Or simplified: { status: 'success', data: { status: '100', pdf: '...' } } depending on router.
                // Based on user provided JSON:
                // {"status":"success", ..., "data":{"status":"success", ..., "data":{"status":"100", ..., "pdf":"..."}}}
                
                $is_success = false;
                $inner_data = [];

                if (isset($result['status']) && $result['status'] === 'success') {
                    if (isset($result['data']['data']['status']) && $result['data']['data']['status'] == "100") {
                        $is_success = true;
                        $inner_data = $result['data']['data'];
                    } elseif (isset($result['data']['status']) && $result['data']['status'] == "100") {
                         // Fallback for simpler structure
                        $is_success = true;
                        $inner_data = $result['data'];
                    }
                }

                if ($is_success && !empty($inner_data['pdf'])) {
                    $pdf_full = $inner_data['pdf'];
                    // Clean base64 if needed
                    if (strpos($pdf_full, 'base64,') !== false) {
                        $pdf_base64_raw = explode('base64,', $pdf_full, 2)[1];
                    } else {
                        $pdf_base64_raw = $pdf_full;
                    }

                    // Debit Wallet
                    $debit = mysqli_query($ahk_conn, "UPDATE users SET balance = balance - {$fee} WHERE phone = '{$username}'");
                    $insert_history = mysqli_query($ahk_conn, "INSERT INTO `wallethistory`
                        (`userid`, `amount`, `balance`, `purpose`, `status`, `type`, `date`)
                        VALUES ('{$username}', '{$fee}', '{$debit_fee}', 'Eshram PDF Download', '1', 'Debit', NOW())");

                    if ($debit && $insert_history) {
                        $show_preview = true;
                        $result_data = $inner_data;
                        echo "<script>Swal.fire('Success', 'PDF Generated Successfully', 'success');</script>";
                    } else {
                        echo "<script>Swal.fire('Database Error', 'Failed to update wallet', 'error');</script>";
                    }
                } else {
                    $msg = $result['message'] ?? 'Unknown Error';
                    if (isset($result['data']['message'])) $msg = $result['data']['message'];
                    if (isset($result['data']['data']['message'])) $msg = $result['data']['data']['message']; // Deep message
                    
                    echo "<script>Swal.fire('Failed', '" . addslashes($msg) . "', 'error');</script>";
                }
            }
        }
    } else {
        echo "<script>
            Swal.fire('Insufficient Balance', 'Please Recharge Your Wallet', 'error');
            setTimeout(() => window.location.href = 'wallet.php', 3000);
        </script>";
    }
}
?>

<!-- HTML STARTS -->
<div class="page-wrapper">
    <div class="page-content">
        <!-- Breadcrumb -->
        <div class="page-breadcrumb d-flex align-items-center justify-content-between mb-4 p-3 bg-white rounded shadow-sm">
            <div class="d-flex align-items-center">
                <div class="breadcrumb-title pe-3">Services</div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 ps-2">
                        <li class="breadcrumb-item active text-muted" aria-current="page">E-Shram Card PDF</li>
                    </ol>
                </nav>
            </div>
        </div>

        <div class="container-fluid pt-4 px-4">
            <div class="row g-4">
                <!-- Search Form -->
                <div class="col-sm-12 col-xl-6">
                    <div class="bg-white rounded h-100 p-4 shadow-sm">
                        <h6 class="mb-4 text-primary">Search E-Shram Details</h6>
                        <form method="post">
                            <div class="mb-3">
                                <label for="aadhaar" class="form-label">Aadhaar Number / UID</label>
                                <input type="text" class="form-control" id="aadhaar" name="aadhaar" 
                                       placeholder="Enter 12-digit Aadhaar Number" 
                                       pattern="[0-9]{12}" 
                                       maxlength="12" 
                                       value="<?php echo htmlspecialchars($aadhaar); ?>" required>
                            </div>
                            <div class="d-flex justify-content-between align-items-center">
                                <small class="text-muted">Fee: ₹<?php echo number_format($fee, 2); ?></small>
                                <button type="submit" name="find" class="btn btn-primary">
                                    <i class="bi bi-search me-1"></i> Search & Download
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Result Section -->
                <?php if ($show_preview && !empty($result_data)): ?>
                <div class="col-sm-12 col-xl-6">
                    <div class="bg-white rounded h-100 p-4 shadow-sm">
                        <h6 class="mb-4 text-success">User Details Found</h6>
                        <div class="table-responsive">
                            <table class="table table-borderless">
                                <tbody>
                                    <tr>
                                        <th scope="row" class="text-muted" style="width: 35%;">Name</th>
                                        <td class="fw-bold"><?php echo htmlspecialchars($result_data['name'] ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th scope="row" class="text-muted">Aadhaar</th>
                                        <td><?php echo htmlspecialchars($result_data['aadhar'] ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th scope="row" class="text-muted">DOB</th>
                                        <td><?php echo htmlspecialchars($result_data['dob'] ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th scope="row" class="text-muted">Gender</th>
                                        <td><?php echo htmlspecialchars($result_data['gender'] ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th scope="row" class="text-muted">UAN</th>
                                        <td><?php echo htmlspecialchars($result_data['uan'] ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th scope="row" class="text-muted">Mobile</th>
                                        <td><?php echo htmlspecialchars($result_data['contact'] ?? 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <th scope="row" class="text-muted">Address</th>
                                        <td><small><?php echo htmlspecialchars($result_data['address'] ?? 'N/A'); ?></small></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <?php if (!empty($pdf_base64_raw)): ?>
                        <div class="mt-4 text-center">
                            <a download="eshram_<?php echo $aadhaar; ?>.pdf" href="data:application/pdf;base64,<?php echo $pdf_base64_raw; ?>" class="btn btn-success w-100 mb-2">
                                <i class="bi bi-download me-1"></i> Download PDF
                            </a>
                            <!-- Embed Preview -->
                            <object data="data:application/pdf;base64,<?php echo $pdf_base64_raw; ?>" type="application/pdf" width="100%" height="400px" class="border rounded">
                                <p>Your browser does not support PDF embedding. <a href="data:application/pdf;base64,<?php echo $pdf_base64_raw; ?>" download="eshram.pdf">Click here to download</a>.</p>
                            </object>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include('../template/ahkweb/footer.php'); ?>